/*
Copyright (c) 2015 by Luke Richardville (http://codepen.io/lukerichardville/pen/yydVWv)
Modified by Boom Apps

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software. 
*/

jQuery(function($) {
	$.fn.canvasWaves = function(Config) {
		var Settings = {
			backgroundR: 0,
			backgroundG: 0,
			backgroundB: 0,
			fadeSpeed: 0.3,
			hideEdges: true,
			animateHueBase: false,
			fixedHueHue: 290,
			saturation: 70,
			lightness: 50,
			opacity:0.15,
			positionLeft: 'centerleft', // topleft, centerleft, bottomleft, topcenter
			positionRight: 'centerright', //bottomright, centerright, topright, bottomcenter
			speed: 4,
			particleCount: 20,
			expand: false,
			fps: 30
		}
		
		Settings = $.extend(true, Settings, Config);
		var hideOffset = 0;
		if (Settings.hideEdges) { hideOffset = 100; }
		var c = $(this)[0],
			cP = $(this).parent();
		var ctx = c.getContext('2d');
			
		var	W = c.width = $(cP).width(),
			H = c.height = $(cP).height(),
			particles = [],
			particleCount = Settings.particleCount,
			tick = 0;

		var startPosXX, startPosXY, startPostYX, startPosYY;
		for (var i = 0; i < particleCount; i++) {
		  particles.push(new particle());
		}

		function particle() {
		  this.location = {
			cp1x: Math.random() * W,
			cp1y: Math.random() * H,
			cp2x: Math.random() * W,
			cp2y: Math.random() * H
		  };
		  this.lineWidth = Math.random() * 3;
		  this.radius = 3;
		  this.speed = Settings.speed;
		  this.angle = Math.random() * 360;
		}

		function draw() {
		  tick++;
		  ctx.fillStyle = 'rgba(' + Settings.backgroundR + ', ' + Settings.backgroundG + ', ' + Settings.backgroundB + ', ' + Settings.fadeSpeed + ')';
		  ctx.fillRect(0, 0, W, H);
		  for (var i = 0; i < particles.length; i++) {
				var p = particles[i];
			  ctx.beginPath();
			  ctx.moveTo(startPosXX, startPosXY);
			  ctx.bezierCurveTo(
				p.location.cp1x, p.location.cp1y, 
				p.location.cp2x, p.location.cp2y, 
				startPosYX, startPosYY
			  );
				ctx.lineWidth = p.lineWidth;
				if (Settings.animateHueBase) {
					ctx.strokeStyle = 'hsla(' + tick % 360 + ', ' + Settings.saturation + '%, ' + Settings.lightness + '%, ' + Settings.opacity + ')';
				} else {
					ctx.strokeStyle = 'hsla(' + Settings.fixedHueHue + ', ' + Settings.saturation + '%, ' + Settings.lightness + '%, ' + Settings.opacity + ')';
				}
			  ctx.stroke();
			  

			  
			  p.location.cp1x = p.location.cp1x + (p.speed * Math.cos(p.angle * Math.PI / 180));
			  p.location.cp1y = p.location.cp1y + (p.speed * Math.sin(p.angle * Math.PI / 180));
			  p.location.cp2x = p.location.cp2x + (p.speed * Math.cos(p.angle * Math.PI / 180));
			  p.location.cp2y = p.location.cp2y + (p.speed * Math.sin(p.angle * Math.PI / 180));
			
			  if (Settings.expand) {
				  if (p.location.cp1x < -W) p.location.cp1x = W;
				  if (p.location.cp2x < -W) p.location.cp2x = W;
				  if (p.location.cp1x > W*2) p.location.cp1x = 0;
				  if (p.location.cp2x > W*2) p.location.cp2x = 0;
				
				  if (p.location.cp1y < -H) p.location.cp1y = H;
				  if (p.location.cp2y < -H) p.location.cp2y = H;
				  if (p.location.cp1y > H*2) p.location.cp1y = 0;
				  if (p.location.cp2y > H*2) p.location.cp2y = 0;
			  } else {
				  if (p.location.cp1x < 0) p.location.cp1x = W;
				  if (p.location.cp2x < 0) p.location.cp2x = W;
				  if (p.location.cp1x > W) p.location.cp1x = 0;
				  if (p.location.cp2x > W) p.location.cp2x = 0;
				
				  if (p.location.cp1y < 0) p.location.cp1y = H;
				  if (p.location.cp2y < 0) p.location.cp2y = H;
				  if (p.location.cp1y > H) p.location.cp1y = 0;
				  if (p.location.cp2y > H) p.location.cp2y = 0;
			  }
		  }
		}

		function resize() {
		  c.width = W = $(cP).width();
		  c.height = H = $(cP).height();
		  
		  switch (Settings.positionLeft) {
				case "topleft":
					startPosXX = 0 - hideOffset;
					startPosXY = 0 - hideOffset;
				break;
				
				case "centerleft":
					startPosXX = 0 - hideOffset;
					startPosXY = H / 2;
				break;
				
				case "bottomleft":
					startPosXX = 0 - hideOffset;
					startPosXY = H + hideOffset;
				break;
				
				case "topcenter":
					startPosXX = W / 2;
					startPosXY = 0 - hideOffset;
				break;	
				
				default:
					startPosXX = 0 - hideOffset;
					startPosXY = 0 - hideOffset;
				break;
			}
			
		  switch (Settings.positionRight) {
				case "bottomright":
					startPosYX = W + hideOffset;
					startPosYY = H + hideOffset;
				break;
				
				case "centerright":
					startPosYX = W + hideOffset;
					startPosYY = H / 2;
				break;
				
				case "topright":
					startPosYX = W + hideOffset;
					startPosYY = 0 - hideOffset;
				break;
				
				case "bottomcenter":
					startPosYX = W / 2;
					startPosYY = H + hideOffset;
				break;	
				
				default:
					startPosYX = W + hideOffset;
					startPosYY = H + hideOffset;
				break;
			}
			
		}

		$(window).load(resize);
		$(window).resize(resize);
		resize();
		
		setInterval(draw, 1000 / Settings.fps);
	}
});